<?php
require_once __DIR__ . '/db.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <title>Profiles Gallery</title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"/>
  <style>
    body { background:#0b0f14; color:#e8eef6; }
    .card { background:#121826; border:1px solid #1e2a3a; }
    .form-control { background:#0f1623; color:#e8eef6; border-color:#1e2a3a; }
    .card-img-top { object-fit: cover; height: 220px; }
    .truncate-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }
  </style>
</head>
<body class="container py-4">
<?php
$pdo = pdoConn();
$perPage = 24;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $perPage;
$search = trim($_GET['q'] ?? '');
$params = [];
$where = '';
if ($search !== '') {
  $where = "WHERE name LIKE :q OR location LIKE :q OR occupation LIKE :q";
  $params[':q'] = "%$search%";
}
$total = $pdo->prepare("SELECT COUNT(*) AS c FROM profiles $where");
$total->execute($params);
$count = (int)$total->fetchColumn();

$stmt = $pdo->prepare("SELECT * FROM profiles $where ORDER BY created_at DESC, id DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
if ($search !== '') { $stmt->bindValue(':q', "%$search%", PDO::PARAM_STR); }
$stmt->execute();
$rows = $stmt->fetchAll();
$pages = max(1, (int)ceil($count / $perPage));
?>
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Profiles</h1>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-outline-light" href="index.php">Image Gen</a>
      <a class="btn btn-sm btn-primary" href="profiles.php">+ Generate profile</a>
    </div>
  </div>
  <form class="row g-2 mb-3" method="get">
    <div class="col-10 col-md-6">
      <input class="form-control" name="q" value="<?= htmlspecialchars($search) ?>" placeholder="Search by name, location, occupation..." />
    </div>
    <div class="col-2 col-md-2">
      <button class="btn btn-outline-secondary w-100">Search</button>
    </div>
  </form>
  <?php if (empty($rows)): ?>
    <div class="alert alert-info">No profiles found. Try generating some or adjust your search.</div>
  <?php else: ?>
    <div class="row g-3">
      <?php foreach ($rows as $r): ?>
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <div class="card h-100">
            <?php
              $imgPath = 'uploads/profiles/' . ($r['image_filename'] ?: '');
              $imgExists = $r['image_filename'] && file_exists(__DIR__ . '/' . $imgPath);
            ?>
            <img class="card-img-top" src="<?= $imgExists ? $imgPath : 'https://placehold.co/600x400?text=No+Image' ?>" alt="portrait">
            <div class="card-body d-flex flex-column">
              <h5 class="card-title mb-1">
                <?= htmlspecialchars($r['name']) ?><?= $r['age'] ? ', ' . (int)$r['age'] : '' ?>
              </h5>
              <div class="text-muted small mb-2">
                <?= htmlspecialchars($r['location']) ?> <?php if ($r['occupation']): ?> • <?= htmlspecialchars($r['occupation']) ?><?php endif; ?>
              </div>
              <p class="card-text truncate-3"><?= htmlspecialchars($r['bio']) ?></p>
              <div class="mt-auto">
                <details class="mb-2">
                  <summary>Desires</summary>
                  <div class="small mt-1"><?= nl2br(htmlspecialchars($r['desires'])) ?></div>
                </details>
                <div class="small"><b>Seeking:</b> <?= htmlspecialchars($r['seeking']) ?></div>
              </div>
            </div>
            <div class="card-footer text-muted small">
              <?= htmlspecialchars($r['created_at']) ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <nav class="mt-4">
      <ul class="pagination">
        <?php
          $makeLink = function($p) use($search) {
            $params = [];
            if ($search !== '') $params['q'] = $search;
            $params['page'] = $p;
            return '?' . http_build_query($params);
          };
        ?>
        <li class="page-item <?= $page<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= $makeLink(max(1,$page-1)) ?>">Prev</a>
        </li>
        <?php for ($p=max(1,$page-2); $p<=min($pages,$page+2); $p++): ?>
          <li class="page-item <?= $p==$page?'active':'' ?>">
            <a class="page-link" href="<?= $makeLink($p) ?>"><?= $p ?></a>
          </li>
        <?php endfor; ?>
        <li class="page-item <?= $page>=$pages?'disabled':'' ?>">
          <a class="page-link" href="<?= $makeLink(min($pages,$page+1)) ?>">Next</a>
        </li>
      </ul>
    </nav>
  <?php endif; ?>
</body>
</html>
