<?php ?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Venice.ai Image Generator</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#0b0f14; color:#e8eef6; }
    .card { background:#121826; border:1px solid #1e2a3a; }
    .form-control,.form-select{ background:#0f1623; color:#e8eef6; border-color:#1e2a3a; }
    .nav-tabs .nav-link.active { background:#121826; border-color:#1e2a3a #1e2a3a #121826; }
    .thumb{border-radius:.75rem; width:100%; height:auto;}
  </style>
</head>
<body>
<div class="container py-4">
  <h1 class="mb-3">Venice.ai — Text → Image & Edit from Photo</h1>

  <ul class="nav nav-tabs" id="modeTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="txt-tab" data-bs-toggle="tab" data-bs-target="#txt" type="button" role="tab">Text → Image</button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="edit-tab" data-bs-toggle="tab" data-bs-target="#edit" type="button" role="tab">Edit from Photo</button>
    </li>
  </ul>

  <div class="tab-content pt-3">
    <div class="tab-pane fade show active" id="txt" role="tabpanel">
      <div class="row g-4">
        <div class="col-lg-4">
          <div class="card p-3">
            <form id="genForm" class="vstack gap-3">
              <div>
                <label class="form-label">Prompt</label>
                <textarea class="form-control" id="prompt" rows="4" placeholder="a professional portrait lighting, soft rim light, detailed skin"></textarea>
              </div>
              <div class="row g-2">
                <div class="col-8">
                  <label class="form-label">Model</label>
                  <select id="model" class="form-select"><option value="hidream">hidream</option></select>
                </div>
                <div class="col-4">
                  <label class="form-label">Variants</label>
                  <select id="variants" class="form-select"><option>1</option><option selected>2</option><option>3</option><option>4</option></select>
                </div>
              </div>
              <div>
                <label class="form-label">Style (optional)</label>
                <select id="style_preset" class="form-select"><option value="">(none)</option></select>
              </div>
              <div class="row g-2">
                <div class="col-6">
                  <label class="form-label">Width</label>
                  <input type="number" class="form-control" id="width" value="1024" min="64" max="1280" step="64">
                </div>
                <div class="col-6">
                  <label class="form-label">Height</label>
                  <input type="number" class="form-control" id="height" value="1024" min="64" max="1280" step="64">
                </div>
              </div>
              <div class="row g-2">
                <div class="col-6">
                  <label class="form-label">Steps</label>
                  <input type="number" class="form-control" id="steps" value="20" min="1" max="50">
                </div>
                <div class="col-6">
                  <label class="form-label">CFG Scale</label>
                  <input type="number" class="form-control" id="cfg_scale" value="7.5" min="0.1" max="20" step="0.1">
                </div>
              </div>
              <div class="row g-2">
                <div class="col-6">
                  <label class="form-label">Format</label>
                  <select id="format" class="form-select"><option>webp</option><option>png</option><option>jpeg</option></select>
                </div>
                <div class="col-6 d-flex align-items-end">
                  <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="safe_mode" checked>
                    <label class="form-check-label" for="safe_mode">Safe mode</label>
                  </div>
                </div>
              </div>
              <button type="submit" class="btn btn-primary w-100">Generate</button>
            </form>
          </div>
          <div id="txtError" class="alert alert-danger mt-3 d-none" role="alert"></div>
        </div>
        <div class="col-lg-8"><div class="row" id="resultsRow"></div></div>
      </div>
    </div>

    <div class="tab-pane fade" id="edit" role="tabpanel">
      <div class="row g-4">
        <div class="col-lg-4">
          <div class="card p-3">
            <form id="editForm" class="vstack gap-3" enctype="multipart/form-data">
              <div>
                <label class="form-label">Upload reference photo (the person)</label>
                <input class="form-control" type="file" id="image_file" name="image_file" accept="image/*" required>
              </div>
              <div>
                <label class="form-label">Edit prompt</label>
                <textarea class="form-control" id="edit_prompt" name="prompt" rows="4" placeholder="Generate the same person in a business suit, studio lighting, 50mm look"></textarea>
              </div>
              <button type="submit" class="btn btn-primary w-100">Generate from Photo</button>
              <small class="text-muted">The server sends your image to <code>/image/edit</code> and returns a PNG.</small>
            </form>
          </div>
          <div id="editError" class="alert alert-danger mt-3 d-none" role="alert"></div>
        </div>
        <div class="col-lg-8"><div id="editResult"></div></div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
async function fetchJSON(url, opts={}) {
  const res = await fetch(url, Object.assign({}, opts));
  const text = await res.text();
  if (!res.ok) throw new Error(text || ('HTTP '+res.status));
  try { return JSON.parse(text); } catch { throw new Error(text); }
}
function show(elId, show){ const el=document.getElementById(elId); if(!el) return; el.classList[show?'remove':'add']('d-none'); }

// Load styles & models for text-to-image
(async function initMeta(){
  try{
    const s = await fetchJSON('styles.php'); const styles = s?.data||[];
    const sel = document.getElementById('style_preset'); styles.forEach(x=>{ const o=document.createElement('option'); o.value=x; o.textContent=x; sel.appendChild(o); });
  } catch(e){ console.warn('styles failed'); }
  try{
    const m = await fetchJSON('models.php'); const models = m?.data||[];
    const sel = document.getElementById('model'); if (models.length) sel.innerHTML = '';
    models.forEach(mm=>{ const id = mm.id||mm.name||'hidream'; const o=document.createElement('option'); o.value=id; o.textContent=id; sel.appendChild(o); });
  } catch(e){ console.warn('models failed'); }
})();

// Text-to-Image
document.getElementById('genForm').addEventListener('submit', async e => {
  e.preventDefault();
  document.getElementById('txtError').classList.add('d-none');
  const payload = {
    prompt: document.getElementById('prompt').value.trim(),
    model: document.getElementById('model').value,
    style_preset: document.getElementById('style_preset').value,
    width: parseInt(document.getElementById('width').value,10)||1024,
    height: parseInt(document.getElementById('height').value,10)||1024,
    steps: parseInt(document.getElementById('steps').value,10)||20,
    cfg_scale: parseFloat(document.getElementById('cfg_scale').value)||7.5,
    variants: parseInt(document.getElementById('variants').value,10)||1,
    format: document.getElementById('format').value,
    safe_mode: document.getElementById('safe_mode').checked
  };
  if (!payload.prompt){ document.getElementById('txtError').textContent='Please enter a prompt.'; document.getElementById('txtError').classList.remove('d-none'); return; }
  try {
    const res = await fetchJSON('generate.php', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload)});
    const images = res?.images || [];
    const row = document.getElementById('resultsRow'); row.innerHTML='';
    if (!images.length){ document.getElementById('txtError').textContent='No images returned.'; document.getElementById('txtError').classList.remove('d-none'); return; }
    images.forEach((b64, idx)=>{
      const col = document.createElement('div'); col.className='col-md-6 mb-4';
      col.innerHTML = `<div class="card p-2"><img class="thumb" src="data:image/${payload.format};base64,${b64}" alt="Generated ${idx+1}"><a class="btn btn-outline-light btn-sm mt-2" href="data:image/${payload.format};base64,${b64}" download="venice_image_${idx+1}.${payload.format}">Download</a></div>`;
      row.appendChild(col);
    });
  } catch(err){ console.error(err); document.getElementById('txtError').textContent = 'Error: ' + err.message; document.getElementById('txtError').classList.remove('d-none'); }
});

// Edit-from-Photo
document.getElementById('editForm').addEventListener('submit', async e => {
  e.preventDefault();
  document.getElementById('editError').classList.add('d-none');
  const fd = new FormData(document.getElementById('editForm'));
  if (!fd.get('image_file')){ document.getElementById('editError').textContent='Please choose an image.'; document.getElementById('editError').classList.remove('d-none'); return; }
  if (!fd.get('prompt') || !fd.get('prompt').toString().trim()){ document.getElementById('editError').textContent='Please enter an edit prompt.'; document.getElementById('editError').classList.remove('d-none'); return; }
  try{
    const res = await fetchJSON('edit.php', { method:'POST', body: fd });
    const b64 = res?.image;
    if (!b64){ document.getElementById('editError').textContent='No image returned.'; document.getElementById('editError').classList.remove('d-none'); return; }
    const box = document.getElementById('editResult');
    box.innerHTML = `<div class="card p-2"><img class="thumb" src="data:image/png;base64,${b64}" alt="Edited"><a class="btn btn-outline-light btn-sm mt-2" href="data:image/png;base64,${b64}" download="venice_edit.png">Download</a></div>`;
  } catch(err){ console.error(err); document.getElementById('editError').textContent = 'Error: ' + err.message; document.getElementById('editError').classList.remove('d-none'); }
});
</script>
</body>
</html>