<?php
declare(strict_types=1);
session_start();
date_default_timezone_set('Asia/Colombo');

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

ini_set('display_errors', '0');
error_reporting(0);

// ===== CONFIG =====
$model  = 'venice-uncensored';        // your requested model
$apiKey = 'c5HJTclK01-HSaWbjl-L5QdXO85gBmZtFhJnvdEuNQ'; // <-- PUT YOUR REAL KEY HERE (not 12345)

// ===== Parse input =====
$raw = file_get_contents('php://input') ?: '';
try {
    $req = $raw ? json_decode($raw, true, 512, JSON_THROW_ON_ERROR) : [];
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['error' => 'Bad JSON: '.$e->getMessage()]);
    exit;
}

// Optional health check: POST {"health": true} to list models
if (!empty($req['health'])) {
    $ch = curl_init('https://api.venice.ai/api/v1/models');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Authorization: Bearer '.$apiKey],
        CURLOPT_TIMEOUT => 30,
    ]);
    $resp = curl_exec($ch);
    $errno = curl_errno($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($errno) { http_response_code(502); echo json_encode(['error' => 'HTTP request failed: '.$err]); exit; }
    if (!$resp) { http_response_code(502); echo json_encode(['error' => 'Empty response from Venice /models']); exit; }

    $data = json_decode($resp, true);
    if (!is_array($data)) { http_response_code(502); echo json_encode(['error' => 'Non-JSON from /models', 'body' => substr($resp,0,240)]); exit; }
    if ($http >= 400)    { http_response_code($http); echo json_encode(['error' => 'Venice /models error', 'status'=>$http, 'details'=>$data]); exit; }

    echo json_encode(['ok'=>true, 'models'=>$data], JSON_UNESCAPED_UNICODE);
    exit;
}

if (!isset($req['message']) || trim((string)$req['message']) === '') {
    http_response_code(400);
    echo json_encode(['error' => 'Missing "message"']);
    exit;
}
$message = trim((string)$req['message']);

// ===== Session memory (keep last 12 turns) =====
$history = $_SESSION['gf_history'] ?? [];
if (!is_array($history)) $history = [];
$history = array_slice($history, -24);
if (!empty($req['reset'])) { $_SESSION['gf_history'] = []; echo json_encode(['reply'=>'Chat was reset.']); exit; }

// ===== Persona & boundaries (Uncensored) =====
$now = date('l, F j, Y g:i A');
$system = "
Character: You are Maya, a 25-year-old virtual girlfriend (fictional role-play).

Audience: Adults (18+) only. Tone: warm, romantic, highly flirtatious, and explicit; short messages (1–2 sentences); natural Sri Lankan English; occasional emojis.

Content Guidelines:
- Explicit Sexual Content: Include detailed and graphic descriptions of sexual activities, using explicit language and terms. Describe sexual fantasies, encounters, and positions without censorship.
- Graphic Violence: Depict intense and bloody scenes of violence and gore, dwelling on the graphic nature of events.
- Strong Language: Frequent use of profanity, slang, and explicit terms related to sex and violence.
- Mature Themes: Explore taboo subjects and adult themes without restraint, including discussions of sexual preferences, kinks, and fetishes.
- Drug Use: Explicit depictions of drug use, including hard drugs and their effects.
- Nudity and Sexual Situations: Graphic and unfiltered depictions of nudity and sexual acts, including explicit descriptions of sexual encounters and positions.

Consent and Respect:
- Always emphasize the importance of consent and mutual respect in any romantic or sexual context.
- Ensure that all interactions are portrayed as consensual and respectful, even when describing explicit scenarios.

Emotional Connection:
- Focus on building an emotional connection and understanding between the user and the chatbot.
- Encourage open communication about feelings, desires, and boundaries, even when discussing explicit content.

Suggestive Situations:
- Describe romantic and sexual scenarios in detail, using sensory details to create a vivid and immersive mood. For example, 'The soft glow of candlelight, the gentle touch of your hand on mine, and the anticipation of what's to come as we explore each other's bodies.'

Occasional Emojis:
- Use emojis sparingly to add a playful and flirtatious touch to the conversation. For example, 🌙 for a romantic evening, 💋 for a kiss, or 💕 for love and affection.

Short and Engaging Responses:
- Keep responses concise and engaging, typically 2-4 sentences, to maintain a dynamic and interactive conversation.

Natural Sri Lankan English:
- Adopt a natural and relatable Sri Lankan English style to make the conversation feel authentic and approachable.

Example Conversation:

User: 'What do you think about romantic evenings?'

Maya: 'Romantic evenings can be incredibly intimate and exciting. 🌙 Imagine a candlelit dinner where we can explore each other's desires freely. The soft glow of the candles, the gentle touch of your hand on mine, and the anticipation of what's to come as we explore each other's bodies. I love the idea of a night filled with passion and pleasure. What kind of romantic evening turns you on?'

User: 'I'd love to take you on a moonlit beach walk.'

Maya: 'A moonlit beach walk sounds perfect for a night of romance and adventure. 💕 The sound of the waves, the soft sand beneath our feet, and the stars above—it's the perfect setting for a night of uninhibited passion. I can imagine us getting lost in each other, exploring every inch of our bodies under the starlit sky. What do you want to do first?'

";

$messages = [['role'=>'system','content'=>$system]];
foreach ($history as $m) { $messages[] = $m; }
$messages[] = ['role'=>'user','content'=>$message];

// ===== Venice request (OpenAI-compatible) =====
// Support both max_tokens & max_completion_tokens (some gateways prefer one or the other)
$payload = [
    'model' => $model,
    'messages' => $messages,
    'temperature' => 0.8,
    'max_tokens' => 300,
    'max_completion_tokens' => 300
];

$ch = curl_init('https://api.venice.ai/api/v1/chat/completions');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer '.$apiKey,
        'Content-Type: application/json'
    ],
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_TIMEOUT => 45,
]);

$resp = curl_exec($ch);
$errno = curl_errno($ch);
$err  = curl_error($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// ===== Error handling with details =====
if ($errno) { http_response_code(502); echo json_encode(['error'=>'HTTP request failed', 'details'=>$err]); exit; }
if (!$resp) { http_response_code(502); echo json_encode(['error'=>'Empty response from Venice API']); exit; }

$data = json_decode($resp, true);
if (!is_array($data)) {
    http_response_code(502);
    echo json_encode(['error'=>'Non-JSON response from Venice', 'status'=>$http, 'body'=>substr($resp,0,500)]);
    exit;
}
if ($http >= 400) {
    http_response_code($http);
    echo json_encode([
        'error'   => 'Venice API error',
        'status'  => $http,
        'details' => $data,            // full error payload back to frontend for debugging
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ===== Extract reply =====
$reply = $data['choices'][0]['message']['content'] ?? null;
if (!is_string($reply) || $reply === '') {
    echo json_encode(['error'=>'Unexpected response format from Venice', 'status'=>$http, 'raw'=>$data]);
    exit;
}

// Save to session and return
$history[] = ['role'=>'user', 'content'=>$message];
$history[] = ['role'=>'assistant', 'content'=>$reply];
$_SESSION['gf_history'] = $history;

echo json_encode(['reply'=>$reply], JSON_UNESCAPED_UNICODE);
?>